//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf8104746_0a67_46d8_aa4e_eb334ea52520
{
    public class Class_ValueChanged : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Threshold = 1,
            Mode = 2
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Threshold = inputs[(int)InputId.Threshold].Eval(context).Value;
            var Mode = (int) inputs[(int)InputId.Mode].Eval(context).Value;
            //<<< _params
             
            if(!_initialized) {
                _initialized = true;
                _lastValue = Value;
                context.Value = 0;
                return context;
            }
            
            if( Changed || context.Time != _lastTime) {
                _lastTime = context.Time;
                _lastValue = _value;
                _value = Value;
            }
            
            switch ((int)Mode)
            {                
                case 0: context.Value = _value > _lastValue + Threshold ? 1 : 0; break;
                case 1: context.Value = _value < _lastValue - Threshold ? 1 : 0; break;
                case 2: context.Value = (_value < _lastValue - Threshold  ||  _value > _lastValue + Threshold)  
                                      ? 1 
                                      : 0; break;
            }
                       
            return context;
        }
        float _value;
        float _lastValue = 0;
        double _lastTime;
        bool _initialized = false;
    }
}

